using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    struct Point
    {
        public long X, Y;
        public Point(long x, long y)
        {
            X = x;
            Y = y;
        }
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        List<Point> points = new List<Point>();

        for (int i = 0; i < n; i++)
        {
            var input = Console.ReadLine().Split().Select(long.Parse).ToArray();
            points.Add(new Point(input[0], input[1]));
        }

        long area = GetAlmostConvexHullArea(points);
        Console.WriteLine(area);
    }

    static long GetAlmostConvexHullArea(List<Point> points)
    {
        List<Point> convexHull = GetConvexHull(points);

        long minArea = long.MaxValue;

        for (int i = 0; i < convexHull.Count; i++)
        {
            List<Point> subset = new List<Point>(convexHull);
            subset.RemoveAt(i); 

            long area = CalculatePolygonArea(subset);
            minArea = Math.Min(minArea, area);
        }

        return minArea;
    }

    static List<Point> GetConvexHull(List<Point> points)
    {
        points = points.OrderBy(p => p.X).ThenBy(p => p.Y).ToList();

        List<Point> hull = new List<Point>();

        foreach (var point in points)
        {
            while (hull.Count >= 2 && CrossProduct(hull[hull.Count - 2], hull[hull.Count - 1], point) <= 0)
                hull.RemoveAt(hull.Count - 1);
            hull.Add(point);
        }

        int lowerHullCount = hull.Count;
        for (int i = points.Count - 1; i >= 0; i--)
        {
            while (hull.Count > lowerHullCount && CrossProduct(hull[hull.Count - 2], hull[hull.Count - 1], points[i]) <= 0)
                hull.RemoveAt(hull.Count - 1);
            hull.Add(points[i]);
        }

        hull.RemoveAt(hull.Count - 1); 
        return hull;
    }

    static long CrossProduct(Point a, Point b, Point c)
    {
        return (b.X - a.X) * (c.Y - a.Y) - (b.Y - a.Y) * (c.X - a.X);
    }

    static long CalculatePolygonArea(List<Point> points)
    {
        long area = 0;
        int n = points.Count;
        for (int i = 0; i < n; i++)
        {
            Point p1 = points[i];
            Point p2 = points[(i + 1) % n];
            area += p1.X * p2.Y - p2.X * p1.Y;
        }
        return Math.Abs(area) / 2;
    }
}